ESPatternClip : ESClip {
  var <pattern, <randSeed, <>isSeeded;
  var player;

  *new { |startTime, duration, pattern, randSeed, isSeeded = true|
    ^super.new(startTime, duration).init(pattern, randSeed, isSeeded);
  }

  init { |argPattern, argRandSeed, argIsSeeded|
    // copy pattern-specific args, with default (random) random seed
    pattern = argPattern;
    randSeed = argRandSeed ?? rand(2000000000);
    isSeeded = argIsSeeded;
  }

  // helper method to return the actual pattern that will be played
  patternToPlay {
    // if this clip is seeded, return the seeded pattern.
    if (isSeeded) {
      ^Pseed(randSeed, pattern);
    } {
      ^pattern;
    }
  }

  // pattern specific stop method
  prStop {
    player.stop;
  }

  // pattern specific start method
  prStart { |startOffset = 0.0, clock|
    // our player from before
    var stream = this.patternToPlay.asStream;
    var wait = stream.fastForward(startOffset);
    player = {
      wait.wait;
      player = EventStreamPlayer(stream).play(clock);
    }.fork(clock);
  }
}