ESTimeline {
  var <tracks;
  var <isPlaying = false;
  var <playbar = 0.0;
  var playBeats, playStartTime, playClock;

  *new { |tracks|
    ^super.newCopyArgs(tracks);
  }

  now {
    if (isPlaying) {
      ^(playClock.beats - playBeats) + playStartTime;
    } {
      ^playbar;
    };
  }

  now_ { |val|
    playbar = max(val, 0);
  }

  stop {
    tracks.do(_.stop);
    //playbar = this.now;
    isPlaying = false;
  }

  play { |startTime, clock|
    // stop if playing
    if (isPlaying) { this.stop };
    isPlaying = true;

    if (startTime.notNil) {
      playbar = startTime;
    };
    // default to play on default TempoClock
    clock = clock ?? TempoClock.default;
    // save the starting conditions
    playClock = clock;
    playBeats = clock.beats;
    playStartTime = playbar;

    tracks.do(_.play(playbar));
  }
}