ESTimelineView : UserView {
  var <timeline;
  var <trackViews;
  var <startTime = -2.0;
  var <duration = 50.0;
  var <trackHeight;
  var clickPoint, clickTime, scrolling = false, originalDuration;

  *new { |parent, bounds, timeline|
    ^super.new(parent, bounds).init(timeline);
  }

  init { |argtimeline|
    var width = this.bounds.width;
    var height = this.bounds.height - 20;

    timeline = argtimeline;
    trackHeight = height / timeline.tracks.size;

    trackViews = timeline.tracks.collect { |track, i|
      var top = i * trackHeight + 20;
      ESTrackView(this, Rect(0, top, width, trackHeight), track)
    };

    this.mouseWheelAction = { |view, x, y, modifiers, xDelta, yDelta|
      var xTime = view.pixelsToAbsoluteTime(x);
      view.duration = view.duration * yDelta.linexp(-100, 100, 0.5, 2, nil);
      view.startTime = xTime - view.pixelsToRelativeTime(x);
      view.startTime = view.startTime + (xDelta * view.duration * -0.002);
    };

    this.drawFunc = {
      var division = (60 / (this.bounds.width / this.duration)).ceil;
      Pen.use {
        Pen.color = Color.black;
        (this.startTime + this.duration + 1).asInteger.do { |i|
          if (i % division == 0) {
            var left = this.absoluteTimeToPixels(i);
            Pen.addRect(Rect(left, 0, 1, 20));
            Pen.fill;
            Pen.stringAtPoint(i.asString, (left + 3)@0, Font("Courier New", 16));
          }
        };
      };
    };

    this.mouseDownAction = { |view, x, y, mods|
      clickPoint = x@y;
      clickTime = this.pixelsToAbsoluteTime(x);
      originalDuration = duration;

      if (y < 20) { scrolling = true } { scrolling = false };
    };

    this.mouseUpAction = { |view, x, y, mods|
      clickPoint = nil;
      clickTime = nil;
      scrolling = false;
      originalDuration = nil;
      this.refresh;
    };

    this.mouseMoveAction = { |view, x, y, mods|
      if (scrolling) {
        var yDelta = y - clickPoint.y;
        var xDelta = x - clickPoint.x;
        if (mods.isAlt) { // hold option to zoom in opposite direction
          yDelta = yDelta.neg;
        };
        duration = (originalDuration * yDelta.linexp(-100, 100, 0.5, 2, nil));
        startTime = (clickTime - this.pixelsToRelativeTime(clickPoint.x));
        startTime = (xDelta.linlin(0, this.bounds.width, startTime, startTime - duration, nil));
        this.refresh;
      };
    };
  }

  // helper functions have become helper methods:
  relativeTimeToPixels { |time| ^(time / duration) * this.bounds.width }
  absoluteTimeToPixels { |clipStartTime| ^this.relativeTimeToPixels(clipStartTime - startTime) }
  pixelsToRelativeTime { |pixels| ^(pixels / this.bounds.width) * duration }
  pixelsToAbsoluteTime { |pixels| ^this.pixelsToRelativeTime(pixels) + startTime }

  startTime_ { |val|
    startTime = val;
    this.refresh;
  }

  duration_ { |val|
    duration = val;
    this.refresh;
  }
}