ESTrackView : UserView {
  var track;

  *new { |parent, bounds, track|
    ^super.new(parent, bounds).init(track);
  }

  init { |argtrack|
    var timelineView = this.parent;
    track = argtrack;

    this.drawFunc_({ |view|
      Pen.use {
        track.clips.do { |clip, j|
          var left = timelineView.absoluteTimeToPixels(clip.startTime);
          var width = timelineView.relativeTimeToPixels(clip.duration);
          Pen.color = Color.hsv(0.5, 0.5, 0.5);
          Pen.addRect(Rect(left, 2, width, this.bounds.height - 4));
          Pen.fill;
        };
      }
    });

    this.acceptsMouse_(false);
  }
}