ESClip {
  var <startTime, <duration;
  var <isPlaying = false;
  var playRout;

  *new { |startTime, duration|
    ^super.newCopyArgs(startTime, duration);
  }

  stop {
    // stop the clip
    this.prStop;
    isPlaying = false;
    // in case of premature stop:
    playRout.stop;
  }

  play { |startOffset = 0.0, clock|
    // default to play on default TempoClock
    clock = clock ?? TempoClock.default;

    // stop if we're playing
    if (isPlaying) {
      this.stop;
    };

    // set isPlaying to true
    isPlaying = true;

    // play the clip on a new Routine on this clock
    playRout = {
      // start the clip from specified start offset
      this.prStart(startOffset, clock);

      // wait the appropriate time, then stop
      (duration - startOffset).wait;
      this.stop;
    }.fork(clock);
  }

  // draw this clip on a UserView using Pen
  draw { |left, top, width, height|
    Pen.color = Color.hsv(0.5, 0.5, 0.5);
    Pen.addRect(Rect(left, top, width, height));
    Pen.fill;
    // if it's more than 5 pixels wide, call the prDraw function
    if (width > 5) {
      this.prDraw(left, top, width, height);
    };
  }

  // override these in subclasses
  prStart { }
  prStop { }
  prDraw { }

  // helper methods
  endTime { ^startTime + duration }
}
