ESTimelineView : UserView {
  var <timeline;
  var <trackViews, <playheadView, playheadRout;
  var <startTime, <duration;
  var <trackHeight;
  var clickPoint, clickTime, scrolling = false, originalDuration;

  *new { |parent, bounds, timeline, startTime = -2.0, duration = 50.0|
    ^super.new(parent, bounds).init(timeline, startTime, duration);
  }

  init { |argtimeline, argstartTime, argduration|
    var width = this.bounds.width;
    var height = this.bounds.height;

    startTime = argstartTime;
    duration = argduration;

    timeline = argtimeline;
    trackHeight = (height - 20) / timeline.tracks.size;

    trackViews = timeline.tracks.collect { |track, i|
      var top = i * trackHeight + 20;
      ESTrackView(this, Rect(0, top, width, trackHeight), track)
    };

    // playhead view from before
    playheadView = UserView(this, this.bounds.copy.origin_(0@0))
    .acceptsMouse_(false)
    .drawFunc_({
      var left;
      Pen.use {
        // sounding playhead in black
        left = this.absoluteTimeToPixels(timeline.soundingNow);
        Pen.addRect(Rect(left, 0, 2, height));
        Pen.color = Color.black;
        Pen.fill;

        if (timeline.isPlaying) {
          // "scheduling playhead" in gray
          Pen.color = Color.gray(0.5, 0.5);
          left = this.absoluteTimeToPixels(timeline.now);
          Pen.addRect(Rect(left, 0, 2, height));
          Pen.fill;
        };
      };
    });

    this.drawFunc_({
      var division = (60 / (this.bounds.width / this.duration)).ceil;
      Pen.use {
        Pen.color = Color.black;
        (this.startTime + this.duration + 1).asInteger.do { |i|
          if (i % division == 0) {
            var left = this.absoluteTimeToPixels(i);
            Pen.addRect(Rect(left, 0, 1, 20));
            Pen.fill;
            Pen.stringAtPoint(i.asString, (left + 3)@0, Font("Courier New", 16));
          }
        };
      };
    }).mouseWheelAction_({ |view, x, y, modifiers, xDelta, yDelta|
      var xTime = view.pixelsToAbsoluteTime(x);
      view.duration = view.duration * yDelta.linexp(-100, 100, 0.5, 2, nil);
      view.startTime = xTime - view.pixelsToRelativeTime(x);
      view.startTime = view.startTime + (xDelta * view.duration * -0.002);
    }).mouseDownAction_({ |view, x, y, mods|
      clickPoint = x@y;
      clickTime = this.pixelsToAbsoluteTime(x);
      originalDuration = duration;

      if (y < 20) { scrolling = true } { scrolling = false };
    }).mouseUpAction_({ |view, x, y, mods|
      // if the mouse didn't move during the click, move the playhead to the click point:
      if (clickPoint == (x@y)) {
        if (timeline.isPlaying.not) {
          timeline.now = clickTime;
        };
      };

      clickPoint = nil;
      clickTime = nil;
      scrolling = false;
      originalDuration = nil;
      this.refresh;
    }).mouseMoveAction_({ |view, x, y, mods|
      if (scrolling) {
        var yDelta = y - clickPoint.y;
        var xDelta = x - clickPoint.x;
        if (mods.isAlt) { // hold option to zoom in opposite direction
          yDelta = yDelta.neg;
        };
        duration = (originalDuration * yDelta.linexp(-100, 100, 0.5, 2, nil));
        startTime = (clickTime - this.pixelsToRelativeTime(clickPoint.x));
        startTime = (xDelta.linlin(0, this.bounds.width, startTime, startTime - duration, nil));
        this.refresh;
      };
    }).keyDownAction_({ |view, char, mods, unicode, keycode, key|
      if (char == $ ) { timeline.togglePlay };
    });

    // call update method on changed
    timeline.addDependant(this);
    this.onClose = { timeline.removeDependant(this) };
  }

  // called when the timeline is changed
  update { |argtimeline, what, value|
    // our play/stop logic from before
    if (what == \isPlaying) {
      if (value) {
        var waitTime = 30.reciprocal; // 30 fps
        playheadRout.stop; // just to make sure
        playheadRout = {
          inf.do {
            playheadView.refresh;
            waitTime.wait;
          };
        }.fork(AppClock) // lower priority clock for GUI updates
      } {
        playheadRout.stop;
        playheadView.refresh;
      };
    };
  }

  // helper methods:
  relativeTimeToPixels { |time| ^(time / duration) * this.bounds.width }
  absoluteTimeToPixels { |clipStartTime| ^this.relativeTimeToPixels(clipStartTime - startTime) }
  pixelsToRelativeTime { |pixels| ^(pixels / this.bounds.width) * duration }
  pixelsToAbsoluteTime { |pixels| ^this.pixelsToRelativeTime(pixels) + startTime }

  startTime_ { |val|
    startTime = val;
    this.refresh;
  }

  duration_ { |val|
    duration = val;
    this.refresh;
  }

  endTime {
    ^startTime + duration;
  }
}