ESTrackView : UserView {
  var track;

  *new { |parent, bounds, track|
    ^super.new(parent, bounds).init(track);
  }

  init { |argtrack|
    var timelineView = this.parent;
    track = argtrack;

    this.drawFunc_({ |view|
      Pen.use {
        track.clips.reverse.do { |clip, j|
          if ((clip.startTime < timelineView.endTime) and: (clip.endTime > timelineView.startTime)) {
            // only draw clips in the timeline view bounds
            var left = timelineView.absoluteTimeToPixels(clip.startTime);
            var width = timelineView.relativeTimeToPixels(clip.duration);
            clip.draw(left, 2, width, this.bounds.height - 4);
          };
        };
      }
    });

    this.acceptsMouse_(false);
  }
}