ESPatternClip : ESClip {
  var <pattern, <randSeed, <>isSeeded;
  var player;
  var drawData;

  *new { |startTime, duration, pattern, randSeed, isSeeded = true|
    ^super.new(startTime, duration).init(pattern, randSeed, isSeeded);
  }

  init { |argPattern, argRandSeed, argIsSeeded|
    // copy pattern-specific args, with default (random) random seed
    pattern = argPattern;
    randSeed = argRandSeed ?? rand(2000000000);
    isSeeded = argIsSeeded;
  }

  // helper method to return the actual pattern that will be played
  patternToPlay {
    // if this clip is seeded, return the seeded pattern.
    if (isSeeded) {
      ^Pseed(randSeed, pattern);
    } {
      ^pattern;
    }
  }

  // pattern specific stop method
  prStop {
    player.stop;
  }

  // pattern specific start method
  prStart { |startOffset = 0.0, clock|
    // our player from before
    var stream = this.patternToPlay.asStream;
    var wait = stream.fastForward(startOffset);
    player = {
      wait.wait;
      player = EventStreamPlayer(stream).play(clock);
    }.fork(clock);
  }

  // data to be drawn on the clip
  drawData {
    // variables we will use later
    var stream, t;

    // return cached data if it exists
    if (drawData.notNil) {
      ^drawData;
    };

    // otherwise calculate it
    stream = this.patternToPlay.asStream;
    drawData = [];
    t = 0.0;
    // keep adding events until we're past the duration (or the stream has run out)
    while { t < duration } {
      // use default Event as the proto event (we need this to be sure of calculating the keys later)
      var event = stream.next(Event.default);
      if (event.notNil) {
        // if the stream has not run out:
        var simpleEvent = event.use {
          (
            freq: event.freq,
            amp: event.amp,
            sustain: event.sustain,
            dur: event.dur,
            // because it doesn't work to specify the isRest parameter directly, as
            // mentioned in part 0
            restdummy: if (event.isRest) { Rest() } { 1 }
          )
        };
        drawData = drawData.add(simpleEvent);
        t = t + simpleEvent.dur;
      } {
        // if the stream has run out:
        t = inf;
      };
    };
    ^drawData;
  }

  // draw the pattern data onto a UserView using Pen
  prDraw { |left, top, width, height|
    var t = 0.0;
    this.drawData.do { |event|
      if (event.isRest.not) {
        var x = left + (t * width / duration);
        var eventWidth = event.sustain * width / duration;
        var eventHeight = 2;
        event.freq.asArray.do { |freq|
          var y = freq.explin(20, 20000, height, top);
          Pen.color = Color.gray(1, event.amp.ampdb.linlin(-60.0, 0.0, 0.0, 1.0));
          Pen.addRect(Rect(x, y, eventWidth, eventHeight));
          Pen.fill;
        };
      };
      t = t + event.dur;
    };
  }
}