ESRoutineClip : ESClip {
  var <routine, <randSeed, <>isSeeded, <>addLatency,
  <>fastForward, // 0 - don't play from middle, 1 - fast forward from middle, 2 - start from beginning always
  <cleanupFunc;
  var player;

  *new { |startTime, duration, func, randSeed, isSeeded = true, addLatency = false, fastForward = 0, cleanupFunc|
    ^super.new(startTime, duration).init(func, randSeed, isSeeded, addLatency, fastForward, cleanupFunc);
  }

  init { |argFunc, argRandSeed, argIsSeeded, argAddLatency, argFastForward, argCleanupFunc|
    routine = ESRoutine(argFunc);
    randSeed = argRandSeed ?? rand(2000000000);
    isSeeded = argIsSeeded;
    addLatency = argAddLatency;
    fastForward = argFastForward;
    cleanupFunc = argCleanupFunc;
  }

  prStop {
    if (isPlaying) {
      {
        if (addLatency) {
          // adjust for server latency
          Server.default.latency.wait;
        };
        player.stop;
        routine.stop;
        cleanupFunc.value;
      }.fork(SystemClock);
    }
  }

  prStart { |startOffset = 0.0, clock|
    routine.reset;
    if (isSeeded) {
      // set random seed
      routine.randSeed = randSeed;
    };
    if ((startOffset > 0) and: (fastForward == 0)) {
      // don't play from middle
      isPlaying = false;
    } {
      player = {
        if (fastForward == 1) {
          // fast forward
          routine.fastForward(startOffset).wait;
        };
        if (addLatency) {
          // adjust for server latency
          (Server.default.latency * clock.tempo).wait;
        };
        routine.play(clock);
      }.fork(clock);
    };
  }
}