ESTimeline {
  var <tracks;
  var <isPlaying = false;
  var <playbar = 0.0;
  var playBeats, playStartTime, playClock;

  *new { |tracks|
    ^super.newCopyArgs(tracks);
  }

  soundingNow {
    if (isPlaying) {
      ^max(playbar, this.now - (playClock.tempo * Server.default.latency));
    } {
      ^this.now;
    }
  }

  now {
    if (isPlaying) {
      ^(playClock.beats - playBeats) + playStartTime;
    } {
      ^playbar;
    };
  }

  now_ { |val|
    playbar = max(val, 0);
  }

  stop {
    tracks.do(_.stop);
    //playbar = this.now;
    isPlaying = false;
    this.changed(\isPlaying, false);
  }

  play { |startTime, clock|
    // stop if playing
    if (isPlaying) { this.stop };
    isPlaying = true;
    this.changed(\isPlaying, true);

    if (startTime.notNil) {
      playbar = startTime;
    };
    // default to play on default TempoClock
    clock = clock ?? TempoClock.default;
    // save the starting conditions
    playClock = clock;
    playBeats = clock.beats;
    playStartTime = playbar;

    tracks.do(_.play(playbar));
  }

  togglePlay {
    if (this.isPlaying) { this.stop } { this.play }
  }
}