ESTrack {
  var <clips;
  var <isPlaying = false;
  var playRout;

  *new { |clips|
    ^super.newCopyArgs(clips);
  }

  sortClips {
    // good to call this before assuming they are ordered
    clips.sort { |a, b|
      a.startTime < b.startTime
    };
  }

  currentClips {
    // returns all playing clips
    ^clips.select(_.isPlaying)
  }

  stop {
    playRout.stop;
    this.currentClips.do(_.stop);
  }

  play { |startTime = 0.0, clock|
    // default to play on default TempoClock
    clock = clock ?? TempoClock.default;
    // stop if we're playing
    if (this.isPlaying) { this.stop };
    // play the track on a new Routine on this clock
    playRout = fork {
      // the variable "t" tracks the current hypothetical playhead
      // as we are scheduling these events
      // it begins at our startTime
      var t = startTime;
      // make sure clips are in order
      this.sortClips;
      // iterate over all the clips
      clips.do { |clip|
        if (clip.endTime < t) {
          // skip all clips previous to t, i.e. startTime
        } {
          // how far into the clip do we need to start
          var offset = max(0, t - clip.startTime);
          // the playhead time we will start playing
          var startTime = clip.startTime + offset;
          // wait the appropriate amount of time
          (startTime - t).wait;
          // ...and play the clip
          clip.play(offset);
          // adjust t to the current time
          t = startTime;
        };
      };
    };
  }
}
